//	IC_FileIO.h

#ifndef _H_IC_FileIO
#define _H_IC_FileIO

#include "CDialogNewDisk.h"

/******************************/
//	WARNING: first 5 entries of 
//	FSType and IC_FileDescIndexType
//	** MUST MATCH **
typedef enum {
	IC_FileDescIndex_UNK, 
	IC_FileDescIndex_GEN, 
	IC_FileDescIndex_DOS1, 
	IC_FileDescIndex_PRO1, 
	IC_FileDescIndex_aPas, 
	IC_FileDescIndex_aCpm, 
	IC_FileDescIndex_IMG1, 
	IC_FileDescIndex_DOS2, 
	IC_FileDescIndex_DOS3, 
	IC_FileDescIndex_PRO2, 
	IC_FileDescIndex_IMG2, 
	IC_FileDescIndex_VDSK, 
	IC_FileDescIndex_hdv, 
	IC_FileDescIndex_dImg, 
	IC_FileDescIndex_2mg, 	
	IC_FileDescIndex_NIBL, 	

	IC_FileDescIndex_NUMTYPES
} IC_FileDescIndexType;

#define	IC_kExtensionLen	6
typedef	char		ExtensionStr[IC_kExtensionLen];

typedef struct {
	OSType			fileType;
	FSType			sectorOrder;
	OSType			fileCreator;
	ExtensionStr	fileExtensionAC;
} IC_FileDescRec;

typedef	IC_FileDescRec		IC_FileTypeArrayRec[IC_FileDescIndex_NUMTYPES];
extern	IC_FileTypeArrayRec	IC_FileTypeArray;

/************************************************/
void	FillInTypeList(OSType *theTypeList, short *numTypes);

char		*strcat_OrderAndExt(
	Boolean					nibblizedB, 
	FSType					sectorOrder, 
	IC_FileDescIndexType	descIndex, 
	char					*defaultNameAC);

IC_FileDescIndexType	GetDescIndex(
	ND_DiscFormatRec	*formatP, 
	ulong				bytesOnDiskL);

OSErr		UpdateFileType(
	DiskImageRec		*imageRec, 
	ND_DiscFormatRec	*formatP, 
	ulong				bytesOnDiskL);

OSErr	FSpGetDiskImageOrder(FSSpecPtr fileSpecP, FSType *fsOrder);

OSErr	ReadChunk(
	DiskImageRec	*imageRec,
	void			*buf, 
	long			start, 
	long			count);

OSErr	WriteChunk(
	DiskImageRec	*imageRec,
	void			*buf, 
	long			start, 
	long			count);

OSErr	ReadImage(DiskImageRec *imageRec);
OSErr	WriteImage(DiskImageRec *imageRec);

#endif